// MainFrm.cpp : implementation of the CMainFrame class
//

#include "stdafx.h"
#include <math.h>
#include "VimosIOTest.h"
#include "PointList.h"
#include "MainFrm.h"

using namespace VIMOS;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const COLORREF RED  = RGB(255,0,0);
const COLORREF GREY = RGB(128,128,128);

/////////////////////////////////////////////////////////////////////////////
// CMainFrame

IMPLEMENT_DYNAMIC(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	//{{AFX_MSG_MAP(CMainFrame)
	ON_WM_CREATE()
	ON_WM_SETFOCUS()
	ON_COMMAND(ID_TEST_X_FLOAT, OnTestXFloat)
	ON_COMMAND(ID_TEST_STOP, OnTestStop)
	ON_UPDATE_COMMAND_UI(ID_TEST_STOP, OnUpdateTestStop)
	ON_UPDATE_COMMAND_UI(ID_TEST_X_FLOAT, OnUpdateTestXFloat)
	ON_WM_CLOSE()
	ON_COMMAND(ID_TEST_X_POINT, OnTestXPoint)
	ON_UPDATE_COMMAND_UI(ID_TEST_X_POINT, OnUpdateTestXPoint)
	ON_COMMAND(ID_TEST_X_ANGLE, OnTestXAngle)
	ON_UPDATE_COMMAND_UI(ID_TEST_X_ANGLE, OnUpdateTestXAngle)
	ON_COMMAND(ID_TEST_X_STRING, OnTestXString)
	ON_UPDATE_COMMAND_UI(ID_TEST_X_STRING, OnUpdateTestXString)
	ON_COMMAND(ID_TEST_X_POINTLIST, OnTestXPointList)
	ON_UPDATE_COMMAND_UI(ID_TEST_X_POINTLIST, OnUpdateTestXPointList)
	ON_COMMAND(ID_TEST_X_IMAGE, OnTestXImage)
	ON_UPDATE_COMMAND_UI(ID_TEST_X_IMAGE, OnUpdateTestXImage)
   ON_MESSAGE(WM_IDLEUPDATECMDUI, OnIdleUpdate)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

static UINT indicators[] =
{
	ID_SEPARATOR,           // status line indicator
	ID_INDICATOR_CAPS,
	ID_INDICATOR_NUM,
	ID_INDICATOR_SCRL,
};

/////////////////////////////////////////////////////////////////////////////
// CMainFrame construction/destruction

CMainFrame::CMainFrame()
: bRunTest(false)
{
	// TODO: add member initialization code here
	
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	// create a view to occupy the client area of the frame
	//if (!m_wndView.Create(NULL, NULL, AFX_WS_DEFAULT_VIEW,
	//	CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST, NULL))
	if (!m_wndView.Create(AFX_WS_DEFAULT_VIEW,
		CRect(0, 0, 0, 0), this, AFX_IDW_PANE_FIRST))
	{
		TRACE0("Failed to create view window\n");
		return -1;
	}
   if (m_MessageFont.CreatePointFont(100, "courier New"))
      m_wndView.SetFont(&m_MessageFont);
	
	if (!m_wndToolBar.CreateEx(this, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
		| CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC) ||
		!m_wndToolBar.LoadToolBar(IDR_MAINFRAME))
	{
		TRACE0("Failed to create toolbar\n");
		return -1;      // fail to create
	}

	if (!m_wndStatusBar.Create(this) ||
		!m_wndStatusBar.SetIndicators(indicators,
		  sizeof(indicators)/sizeof(UINT)))
	{
		TRACE0("Failed to create status bar\n");
		return -1;      // fail to create
	}


   if (!m_wndDlgBar.Create(this, IDD_DIALOG_BAR,
      CBRS_TOP|CBRS_TOOLTIPS|CBRS_FLYBY, IDD_DIALOG_BAR))
   {
		TRACE0("Failed to create dialog bar\n");
		return -1;      // fail to create
   }
   ((CComboBox*)m_wndDlgBar.GetDlgItem(IDC_COM_PORT))->SetCurSel(0);  // COM1
   ((CComboBox*)m_wndDlgBar.GetDlgItem(IDC_BAUD_RATE))->SetCurSel(3); // 9600

	// TODO: Delete these three lines if you don't want the toolbar to
	//  be dockable
	m_wndToolBar.EnableDocking(CBRS_ALIGN_ANY);
	m_wndDlgBar.EnableDocking(CBRS_ALIGN_ANY);
	EnableDocking(CBRS_ALIGN_ANY);
	DockControlBar(&m_wndToolBar);

   RecalcLayout();
   CRect rt;
   m_wndToolBar.GetWindowRect(&rt);
   rt.OffsetRect(1, 0);
	DockControlBar(&m_wndDlgBar, AFX_IDW_DOCKBAR_TOP, &rt);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CFrameWnd::PreCreateWindow(cs) )
		return FALSE;
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	cs.lpszClass = AfxRegisterWndClass(0);
	return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CMainFrame diagnostics

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}

void CMainFrame::Dump(CDumpContext& dc) const
{
	CFrameWnd::Dump(dc);
}

#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CMainFrame message handlers
void CMainFrame::OnSetFocus(CWnd* )
{
	// forward focus to the view window
	m_wndView.SetFocus();
}

BOOL CMainFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
	// let the view have first crack at the command
	if (m_wndView.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
		return TRUE;

	// otherwise, do default handling
	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}


void CMainFrame::OnTestXFloat() 
{
   m_wndView.Clear();
   CString msg;
   float v[] = {0.0F, 1.0F, 2.3F, 3.141F, 5.6789F, -1.0F, -0.001F, -0.0001234567F, -99.9F, 5000000.0F, 100.01F, 1000.01F, 35e-12F };

   IO_RESULT r = Conn.Open(GetPortName(), GetBaudRate());
   if (r != R_OK) {
      msg.Format("Open failed with error %d\n", (int)r);
      m_wndView.Print(msg, RED);
      return;
   }

   SetRunState(true);

   int count = sizeof(v)/sizeof(v[0]);
   for (int i = 0; i < count; ++i) {
      if (Aborted()) {
         break;
      }

      float val = v[i];

      // send
      msg.Format("Sending %g ... ", (double)val);
      m_wndView.Print(msg);
      r = Conn.SendResult(val, CVimosConnection::HEX, 0, true);
      if (r != R_OK) {
         msg.Format("SendResult failed with error %d\n", (int)r);
         m_wndView.Print(msg, RED);
         break;
      }

      // receive
      float f;
      r = Conn.ReceiveResult(f, CVimosConnection::HEX, 0, true, 200);
      if (r != R_OK) {
         msg.Format("ReceiveResult failed with error %d\n", (int)r);
         m_wndView.Print(msg, RED);
         break;
      }
      msg.Format("Received %g\n", (double)f);
      m_wndView.Print(msg, f == val ? 0 : RED);
   }

   SetRunState(false);
   Conn.Close();

   if (i == count)
      m_wndView.Print("Done.\n");
}

void CMainFrame::OnTestStop() 
{
	SetRunState(false);
}

void CMainFrame::OnUpdateTestStop(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(bRunTest);
}

void CMainFrame::OnUpdateTestXFloat(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!bRunTest);
}

bool CMainFrame::Aborted()
{
   if (!theApp.PumpMessages()) {
      // NOTE now this object is deleted!
      return true;
   }

   if (!bRunTest) {
      m_wndView.Print("Test aborted by user\n", RGB(255,0,0));
      return true;
   }

   return false;
}



CString CMainFrame::GetPortName()
{
   CString port;
   m_wndDlgBar.GetDlgItem(IDC_COM_PORT)->GetWindowText(port);
   return port;
}

int CMainFrame::GetBaudRate()
{
   CString baud_str;
   m_wndDlgBar.GetDlgItem(IDC_BAUD_RATE)->GetWindowText(baud_str);
   return atoi(baud_str);
}

LRESULT CMainFrame::OnIdleUpdate(WPARAM, LPARAM)
{
   UpdateDlgBar();

   return Default();
}

void CMainFrame::SetRunState(bool run)
{
   bool change = (run != bRunTest);

   bRunTest = run;

   if (change) {
      UpdateDlgBar();
   }
}

void CMainFrame::UpdateDlgBar()
{
   m_wndDlgBar.GetDlgItem(IDC_COM_PORT)->EnableWindow(!bRunTest);
   m_wndDlgBar.GetDlgItem(IDC_BAUD_RATE)->EnableWindow(!bRunTest);
}

void CMainFrame::OnClose() 
{
   if (bRunTest) {
      m_wndView.Print("Stop the current test before closing the application.\n", GREY);
   }
   else {
	   CFrameWnd::OnClose();
   }
}

void CMainFrame::FillPointList(VIMOS::MEM_POINT_ITEM ptlist[], int count)
{
   const double center_x = 369;
   const double center_y = 286;
   const double d = 100;
   const double pi2 = 6.283185307179586476925286766559;

   for (int i = 0 ; i < count; ++i) {
      double x = center_x + d * cos(pi2 * i / count);
      double y = center_y + d * sin(pi2 * i / count);

      ptlist[i].pt.x = (short)x;
      ptlist[i].pt.subx = (short)((x - (int)x) * 1000);
      ptlist[i].pt.y = (short)y;
      ptlist[i].pt.suby = (short)((y - (int)y) * 1000);

      ptlist[i].fpar[0] = (float)i;
   }
}

void CMainFrame::OnTestXPoint() 
{
   m_wndView.Clear();
   CString msg;
   const int count = 100;
   MEM_POINT_ITEM points[count];
   FillPointList(points, count);

   IO_RESULT r = Conn.Open(GetPortName(), GetBaudRate());
   if (r != R_OK) {
      msg.Format("Open failed with error %d\n", (int)r);
      m_wndView.Print(msg, RED);
      return;
   }

   SetRunState(true);

   for (int i = 0; i < count; ++i) {
      if (Aborted()) {
         break;
      }

      UPM_POINT pt_send = points[i].pt;

      // send
      msg.Format("Sending (%g,%g) ... ", 
         pt_send.x + pt_send.subx / 1000.0, pt_send.y + pt_send.suby / 1000.0);
      m_wndView.Print(msg);
      r = Conn.SendResult(pt_send, CVimosConnection::HEX, 0, true);
      if (r != R_OK) {
         msg.Format("SendResult failed with error %d\n", (int)r);
         m_wndView.Print(msg, RED);
         break;
      }

      // receive
      UPM_POINT pt_recv;
      r = Conn.ReceiveResult(pt_recv, CVimosConnection::HEX, 0, true, 1000);
      if (r != R_OK) {
         msg.Format("ReceiveResult failed with error %d\n", (int)r);
         m_wndView.Print(msg, RED);
         break;
      }
      msg.Format("Received (%g,%g)\n", 
         pt_recv.x + pt_recv.subx / 1000.0, pt_recv.y + pt_recv.suby / 1000.0);
      COLORREF color = (memcmp(&pt_send, &pt_recv, sizeof(UPM_POINT)) == 0) ? 0 : RED;
      m_wndView.Print(msg, color);
   }

   SetRunState(false);
   Conn.Close();

   if (i == count)
      m_wndView.Print("Done.\n");
}

void CMainFrame::OnUpdateTestXPoint(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!bRunTest);
}

void CMainFrame::OnTestXAngle() 
{
   m_wndView.Clear();
   CString msg;

   IO_RESULT r = Conn.Open(GetPortName(), GetBaudRate());
   if (r != R_OK) {
      msg.Format("Open failed with error %d\n", (int)r);
      m_wndView.Print(msg, RED);
      return;
   }

   SetRunState(true);

   const int count = 100;
   for (int i = 0; i < count; ++i) {
      if (Aborted()) {
         break;
      }

      const double pi2 = 6.283185307179586476925286766559;
      UPM_ANGLE angle_send = (UPM_ANGLE)(pi2 * 1000.0 * i / count);

      // send
      msg.Format("Sending %d ... ", (int)angle_send);
      m_wndView.Print(msg);
      r = Conn.SendResult(angle_send, CVimosConnection::HEX, 0, true);
      if (r != R_OK) {
         msg.Format("SendResult failed with error %d\n", (int)r);
         m_wndView.Print(msg, RED);
         break;
      }

      // receive
      UPM_ANGLE angle_recv;
      r = Conn.ReceiveResult(angle_recv, CVimosConnection::HEX, 0, true, 1000);
      if (r != R_OK) {
         msg.Format("ReceiveResult failed with error %d\n", (int)r);
         m_wndView.Print(msg, RED);
         break;
      }
      msg.Format("Received %d\n", (int)angle_recv);
      COLORREF color = (angle_send == angle_recv) ? 0 : RED;
      m_wndView.Print(msg, color);
   }

   SetRunState(false);
   Conn.Close();

   if (i == count)
      m_wndView.Print("Done.\n");
}

void CMainFrame::OnUpdateTestXAngle(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!bRunTest);
}

void CMainFrame::OnTestXString() 
{
   m_wndView.Clear();
   CString msg;

   const char *filter = "Text files (*.txt)|*.txt|All Files (*.*)|*.*||";
   CFileDialog dlg(TRUE, NULL, NULL, OFN_NOCHANGEDIR, filter, this);
   if (dlg.DoModal() != IDOK)
      return;
   CStdioFile file;
   if (!file.Open(dlg.GetPathName(), CFile::modeRead | CFile::shareDenyWrite | CFile::typeText)) {
      msg.Format("Failed to open file %s\n", dlg.GetPathName());
      m_wndView.Print(msg, RED);
      return;
   }

   IO_RESULT r = Conn.Open(GetPortName(), GetBaudRate());
   if (r != R_OK) {
      msg.Format("Open failed with error %d\n", (int)r);
      m_wndView.Print(msg, RED);
      return;
   }

   SetRunState(true);

   CString text_send;
   while (file.ReadString(text_send)) {
      if (Aborted()) {
         break;
      }

      //Conn.GetPort()->Purge();

      // send
      msg.Format("Sending : %s\n", text_send);
      m_wndView.Print(msg);
      r = Conn.SendString(text_send);
      if (r != R_OK) {
         msg.Format("SendString failed with error %d\n", (int)r);
         m_wndView.Print(msg, RED);
         break;
      }

      // receive
      char text_recv[1024] = "";
      r = Conn.ReceiveString(text_recv, sizeof(text_recv));
      if (r != R_OK) {
         msg.Format("ReceiveString failed with error %d\n", (int)r);
         m_wndView.Print(msg, RED);
         break;
      }
      CString reply = text_recv;

      msg.Format("Received: %s\n", reply);
      COLORREF color = (text_send == reply) ? 0 : RED;
      m_wndView.Print(msg, color);
   }

   SetRunState(false);
   Conn.Close();

   if (file.GetPosition() == file.GetLength())
      m_wndView.Print("Done.\n");
}

void CMainFrame::OnUpdateTestXString(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!bRunTest);
}

void CMainFrame::OnTestXPointList() 
{
   m_wndView.Clear();
   CString msg;
   const int count = 500;
   MEM_POINT_ITEM ptlist[count];
   FillPointList(ptlist, count);

   IO_RESULT r = Conn.Open(GetPortName(), GetBaudRate());
   if (r != R_OK) {
      msg.Format("Open failed with error %d\n", (int)r);
      m_wndView.Print(msg, RED);
      return;
   }

   SetRunState(true);

   do {
      if (Aborted()) {
         break;
      }

      // send
      msg.Format("Sending %d points ...\n", count);
      m_wndView.Print(msg);
      r = Conn.SendPointList(ptlist, count, true);
      if (r != R_OK) {
         msg.Format("SendPointList failed with error %d\n", (int)r);
         m_wndView.Print(msg, RED);
         break;
      }

      // receive
      CPointList ptlist_recv;
      r = Conn.ReceivePointList(ptlist_recv, true, false);
      if (r != R_OK) {
         msg.Format("ReceivePointList failed with error %d\n", (int)r);
         m_wndView.Print(msg, RED);
         break;
      }
      msg.Format("Received %d points\n", ptlist_recv.Count());
      COLORREF color = ptlist_recv.Count() == count ? 0 : RED;
      m_wndView.Print(msg, color);
      delete[] ptlist_recv.Data();

      // compare point-lists
      if (ptlist_recv.Count() == count) {
         int j;
         for (j = 0; j < count; ++j) {
            if (memcmp(&ptlist[j], &ptlist_recv.Data()[j], sizeof(MEM_POINT_ITEM)) != 0) {
               break;
            }
         }
         if (j < count) {
            msg.Format("Difference at point %d\n", j);
            m_wndView.Print(msg, RED);
         }
         else m_wndView.Print("No differences\n");
      }
   } while (false);

   SetRunState(false);
   Conn.Close();

   m_wndView.Print("Done.\n");
}

void CMainFrame::OnUpdateTestXPointList(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!bRunTest);
}

void CMainFrame::OnTestXImage() 
{
   m_wndView.Clear();
   CString msg;
   char img_file[MAX_PATH];
   char *file_part;
   ::GetFullPathName("VimosIOTest.jpg", MAX_PATH, img_file, &file_part);

   if (RecvImageDlg.DoModal() != IDOK)
      return;

   IO_RESULT r = Conn.Open(GetPortName(), GetBaudRate());
   if (r != R_OK) {
      msg.Format("Open failed with error %d\n", (int)r);
      m_wndView.Print(msg, RED);
      return;
   }

   SetRunState(true);

   do {
      if (Aborted()) break;

      // send quality factor
      msg.Format("Sending quality factor (%d) ...\n", RecvImageDlg.nQuality);
      m_wndView.Print(msg);
      r = Conn.SendResult((float)RecvImageDlg.nQuality, CVimosConnection::HEX, 0, true);
      if (r != R_OK) {
         msg.Format("Failed to send quality factor, error %d\n", (int)r);
         m_wndView.Print(msg, RED);
         break;
      }

      // send transfer mode
      msg.Format("Sending transfer mode (%s) ...\n", RecvImageDlg.bAsciiTransfer ? "ASCII" : "binary");
      m_wndView.Print(msg);
      r = Conn.SendResult((float)RecvImageDlg.bAsciiTransfer, CVimosConnection::HEX, 0, true);
      if (r != R_OK) {
         msg.Format("Failed to send transfer mode, error %d\n", (int)r);
         m_wndView.Print(msg, RED);
         break;
      }

      // send shutter value
      msg.Format("Sending shutter value (%d) ...\n", RecvImageDlg.nShutter);
      m_wndView.Print(msg);
      r = Conn.SendResult((float)RecvImageDlg.nShutter, CVimosConnection::HEX, 0, true);
      if (r != R_OK) {
         msg.Format("Failed to send shutter value, error %d\n", (int)r);
         m_wndView.Print(msg, RED);
         break;
      }

      // receive image
      m_wndView.Print("Receiving image ...\n");
      r = Conn.ReceiveImage(img_file, 20000);
      if (r != R_OK) {
         msg.Format("ReceiveImage failed with error %d\n", (int)r);
         m_wndView.Print(msg, RED);
         break;
      }
      msg.Format("Image received and saved in %s\n", img_file);
      m_wndView.Print(msg);

      // open image file with the associated application
      int shr = (int)::ShellExecute(GetSafeHwnd(), NULL, img_file, NULL, NULL, SW_SHOWNORMAL);
      if (shr <= 32) {
         msg.Format("ShellExecute failed with error %d\n", shr);
         m_wndView.Print(msg, RED);
         break;
      }
   } while (false);

   SetRunState(false);
   Conn.Close();

   m_wndView.Print("Done.\n");
}

void CMainFrame::OnUpdateTestXImage(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!bRunTest);
}


