// MessageOutput.cpp : implementation file
//

#include "stdafx.h"
#include "MessageOutput.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMessageOutput

CMessageOutput::CMessageOutput() : nMaxLines(0)
{
}

CMessageOutput::~CMessageOutput()
{
}


BEGIN_MESSAGE_MAP(CMessageOutput, CRichEditCtrl)
	//{{AFX_MSG_MAP(CMessageOutput)
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMessageOutput message handlers

// effects - use CFE_xxx codes from CHARFORMAT
void CMessageOutput::Print(LPCSTR text, COLORREF color, DWORD effects)
{
	if (nMaxLines > 0) {
		int lines = GetLineCount();
		if (lines > nMaxLines) {
			SetOptions(ECOOP_AND, (DWORD)~ECO_READONLY);
			int kill_lines = lines - nMaxLines + nMaxLines / 100;
			SetSel(0, LineIndex(kill_lines));
			Clear();
			SetOptions(ECOOP_OR, ECO_READONLY);
		}
	}

	CHARFORMAT format;
	SetSel(-1,-1);
	if (sTimestampFormat != "" && LineLength() == 0) {
		// print out timestamp
		memset(&format, 0, sizeof(format));
		format.cbSize = sizeof(format);
		format.dwEffects = 0;
		format.crTextColor = RGB(100,100,40);
		format.dwMask = CFM_COLOR | CFM_BOLD | CFM_ITALIC | CFM_STRIKEOUT | CFM_UNDERLINE; /*CFM_COLOR;*/

		SetSelectionCharFormat(format);
		CString ts = "[" + CTime::GetCurrentTime().Format(sTimestampFormat) + "] ";
		ReplaceSel(ts);
	}

	memset(&format, 0, sizeof(format));
	format.cbSize = sizeof(format);
	format.dwEffects = effects;
	format.crTextColor = color;
	format.dwMask = CFM_COLOR | CFM_BOLD | CFM_ITALIC | CFM_STRIKEOUT | CFM_UNDERLINE;
	
	SetSel(-1,-1);
	SetSelectionCharFormat(format);
	ReplaceSel(text);

	SendMessage(EM_SCROLLCARET);

   UpdateWindow();
}

void CMessageOutput::PreSubclassWindow() 
{
	// do not select all contents when control receives the focus
	SetOptions(ECOOP_OR, ECO_SAVESEL | ECO_READONLY);

	CRichEditCtrl::PreSubclassWindow();
}

BOOL CMessageOutput::SetMaxLines(int max_lines)
{
	nMaxLines = max_lines;
	if (nMaxLines > 0) {
		int lines = GetLineCount();
		if (lines > nMaxLines) {
			SetOptions(ECOOP_AND, (DWORD)~ECO_READONLY);
			SetSel(0, LineIndex(lines - nMaxLines));
			Clear();
			SetOptions(ECOOP_OR, ECO_READONLY);
		}
	}
	return TRUE;
}

// see strftime() in MSDN
// empty format => don't print timestamp
void CMessageOutput::SetTimestampFormat(LPCSTR format)
{
	sTimestampFormat = format ? format : "";
}

int CMessageOutput::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CRichEditCtrl::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// do not select all contents when control receives the focus
	SetOptions(ECOOP_OR, ECO_SAVESEL | ECO_READONLY);
	
	return 0;
}

BOOL CMessageOutput::PreCreateWindow(CREATESTRUCT& cs) 
{
	cs.style |= WS_HSCROLL | WS_VSCROLL | ES_MULTILINE | ES_AUTOHSCROLL | ES_AUTOVSCROLL;
	return CRichEditCtrl::PreCreateWindow(cs);
}

void CMessageOutput::Clear()
{
   SetWindowText("");
}
