// PointList.h: interface for the CPointList class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_POINTLIST_H__DD094FEA_0470_4843_B7F1_6D8AB3C0FEE5__INCLUDED_)
#define AFX_POINTLIST_H__DD094FEA_0470_4843_B7F1_6D8AB3C0FEE5__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#pragma pack(push)
#pragma pack(1)
#endif // _MSC_VER > 1000

namespace VIMOS
{

/**
 * 2D point with subpixel coordinates.
 * Effective coordinates are \code (x + subx / 1000.0, y + suby / 1000.0) \endcode
 */
struct UPM_POINT
{
    short x;    ///< X coordinate
    short subx; ///< X subpixel coordinate
    short y;    ///< Y coordinate
    short suby; ///< Y subpixel coordinate
};

/// Number of auxiliary parameters in the point-list item (MEM_POINT_ITEM)
const int MEM_POINT_FPARLEN = 8;

/**
 * Point-list item.
 * A point (UPM_POINT) with additional parameters.
 */
struct MEM_POINT_ITEM
{
    UPM_POINT   pt;                        ///< 2D point coordinates with subpixels
    float       fpar[MEM_POINT_FPARLEN];   ///< general purpose parameters associated with the point
};



/**
 * Point-list.
 * This is a simple array of MEM_POINT_ITEM structures.
 * It manages the storage for the point-list.
 * Used in functions that return point-list which length is not known in advance.
 *
 * Objects of this class cannot be copied.
 */
class CPointList
{
public:
   /// Initialize an empty point-list
   CPointList();

   /// Destroy the point-list and free allocated storage
   ~CPointList();

	void Allocate(long item_count);
	void Free();

   /**
    * Access the array of MEM_POINT_ITEM structures.
    * This function can be used to access the point-list items.
    * The length of the returned array is given by Count().
    * 
    * @return Pointer to the array of MEM_POINT_ITEM structures representing the point-list.
    */
   MEM_POINT_ITEM* Data() const { return v_; }

   /// Point-list length
   long Count() const { return item_count_; }

private:
   // copying is not allowed
   CPointList(const CPointList&);
   CPointList& operator=(const CPointList&);

   MEM_POINT_ITEM *v_;
   long item_count_;
};



} // namespace VIMOS

#if _MSC_VER > 1000
#pragma pack(pop)
#endif // _MSC_VER > 1000

#endif // !defined(AFX_POINTLIST_H__DD094FEA_0470_4843_B7F1_6D8AB3C0FEE5__INCLUDED_)

