#ifndef _INCL_ERRORS_H
#define _INCL_ERRORS_H

namespace VIMOS
{

/// Function return codes
enum IO_RESULT
{
   R_OK                 = 0, ///< Success
   R_INVALIDARG         = 1, ///< Invalid function argument
   R_SMALLBUFFER        = 2, ///< Data buffer passed to the function was too small
   R_INTERNAL_ERR       = 3, ///< Internal error
   R_FILE_OPEN_ERR      = 4, ///< File open error
   IO_R_ERROR           = 5, ///< General I/O error
   IO_R_DEVICE_OPEN     = 6, ///< Connection already open
   IO_R_DEVICE_NOT_OPEN = 7, ///< Connection not open
   IO_R_DEVICE_OPEN_ERR = 8, ///< Failed to open connection
   IO_R_SEND_ERR        = 9, ///< Send operation failed
   IO_R_RECV_ERR        = 10,///< Receive operation failed
   IO_R_SEND_TIMEOUT    = 11,///< Timeout while sending
   IO_R_RECV_TIMEOUT    = 12,///< Timeout while receiving
   IO_R_RECV_DATA_ERR   = 13,///< Received data was corrupted
};


} // namespace VIMOS



#endif // _INCL_ERRORS_H
